/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipDLR_error.h 51163 2015-01-29 10:39:41Z kai $:

Description:
  Error Codes of the EthernetIP DLR task

**************************************************************************************/

#ifndef __EIP_DLR_ERROR_H
#define __EIP_DLR_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// Ethernet/IP DLR Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EIP_DLR_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EIP_DLR_COMMAND_INVALID    ((TLR_RESULT)0xC0950001L)

//
// MessageId: TLR_E_EIP_DLR_NOT_INITIALIZED
//
// MessageText:
//
//  DLR task is not initialized.
//
#define TLR_E_EIP_DLR_NOT_INITIALIZED    ((TLR_RESULT)0xC0950002L)

//
// MessageId: TLR_E_EIP_DLR_FNC_API_INVALID_HANDLE
//
// MessageText:
//
//  Invalid DLR handle at API function call.
//
#define TLR_E_EIP_DLR_FNC_API_INVALID_HANDLE ((TLR_RESULT)0xC0950003L)

//
// MessageId: TLR_E_EIP_DLR_INVALID_ATTRIBUTE
//
// MessageText:
//
//  Invalid DLR object attribute.
//
#define TLR_E_EIP_DLR_INVALID_ATTRIBUTE  ((TLR_RESULT)0xC0950004L)

//
// MessageId: TLR_E_EIP_DLR_INVALID_PORT
//
// MessageText:
//
//  Invalid port.
//
#define TLR_E_EIP_DLR_INVALID_PORT       ((TLR_RESULT)0xC0950005L)

//
// MessageId: TLR_E_EIP_DLR_LINK_DOWN
//
// MessageText:
//
//  Port link is down.
//
#define TLR_E_EIP_DLR_LINK_DOWN          ((TLR_RESULT)0xC0950006L)

//
// MessageId: TLR_E_EIP_DLR_MAX_NUM_OF_TASK_INST_EXCEEDED
//
// MessageText:
//
//  Maximum number of EthernetIP task instances exceeded.
//
#define TLR_E_EIP_DLR_MAX_NUM_OF_TASK_INST_EXCEEDED ((TLR_RESULT)0xC0950007L)

//
// MessageId: TLR_E_EIP_DLR_INVALID_TASK_INST
//
// MessageText:
//
//  Invalid task instance.
//
#define TLR_E_EIP_DLR_INVALID_TASK_INST  ((TLR_RESULT)0xC0950008L)

//
// MessageId: TLR_E_EIP_DLR_CALLBACK_NOT_REGISTERED
//
// MessageText:
//
//  Callback function is not registered.
//
#define TLR_E_EIP_DLR_CALLBACK_NOT_REGISTERED ((TLR_RESULT)0xC0950009L)

//
// MessageId: TLR_E_EIP_DLR_WRONG_DLR_STATE
//
// MessageText:
//
//  Wrong DLR state.
//
#define TLR_E_EIP_DLR_WRONG_DLR_STATE    ((TLR_RESULT)0xC095000AL)

//
// MessageId: TLR_E_EIP_DLR_NOT_CONFIGURED_AS_SUPERVISOR
//
// MessageText:
//
//  Not configured as supervisor.
//
#define TLR_E_EIP_DLR_NOT_CONFIGURED_AS_SUPERVISOR ((TLR_RESULT)0xC095000BL)

//
// MessageId: TLR_E_EIP_DLR_INVALID_CONFIG_PARAM
//
// MessageText:
//
//  Configuration parameter is invalid.
//
#define TLR_E_EIP_DLR_INVALID_CONFIG_PARAM ((TLR_RESULT)0xC095000CL)

//
// MessageId: TLR_E_EIP_DLR_NO_STARTUP_PARAM_AVAIL
//
// MessageText:
//
// No startup parameters available.
//
#define TLR_E_EIP_DLR_NO_STARTUP_PARAM_AVAIL ((TLR_RESULT)0xC095000DL)


#endif  //__EIP_DLR_ERROR_H

